//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-3: The Balance Equation and the Mass Balance
//Example: 3.9 Page 94
//Title: Unsteady State Mass Balances
//===================================================================

model Ex3_9

//=============
// Parameter Section 

parameter Real D(unit = "m") = 3 "Diameter of the cylinder";
parameter Real d_1(unit = "m") = 0.1 "Diameter of the inflow pipe";
parameter Real d_2(unit = "m") = 0.2 "Diameter of the outflow line";
parameter Real v_1(unit = "m/s") = 2 "Velocity of water at the inflow";
parameter Real v_2(unit = "m/s") = 1 "Velocity of water at the outflow";

//=============
// Library Section

extends Modelica.Constants;

//=============
// Variable Section

Real dV_sys(unit = "m3/s") "Volumetric flowrate in or out of the system";
Real dz_sur(unit = "m/s") "Rate of fall of liquid level";

//=============
// Equation Section

equation
dV_sys = (pi/4) * ( v_1 * d_1^2 - v_2 * d_2^2 );
dz_sur = dV_sys / ( (pi/4) * D^2 ); 

end Ex3_9;