//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-4: The First Law of Thermodynamics
//Example: 4.2 Page 112
//Title: Kinetic Energy of a Bullet
//===================================================================

model Ex4_2

//=============
// Parameter Section 

parameter Real m(unit = "lbm") = 0.01 "Pound mass of the bullet";
parameter Real v(unit = "ft/s") = 2000 "Speed of the bullet";
parameter Real c(unit = "lbm.ft/lbf.s2") = 32.2 "Conversion factor";

//=============
// Variable Section

Real KE(unit = "ft.lbf") "Kinetic energy of the bullet";

//=============
// Equation Section

equation
KE = m * v^2 / (2 * c);
end Ex4_2;