//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-4: The First Law of Thermodynamics
//Example: 4.7 Page 125
//Title: Increase in Mass upon Heating of Water
//===================================================================

model Ex4_7

//=============
// Parameter Section 

parameter Real m(unit = "lbm") = 1 "Mass of water";
parameter Real t1(unit = "°F") = 59.5 "Initial Temperature";
parameter Real t2(unit = "°F") = 60.5 "Final Temperature";
parameter Real c2(unit = "Btu/lbm") = 3.85 * 10^13 "Speed of light squared";
parameter Real Cp(unit = "Btu/lbm.F") =1 "Specific heat capcity of water";

//=============
// Variable Section

Real Q(unit = "Btu") "Change in heat";
Real dm(unit = "lbm") "Increase in mass";

//=============
// Equation Section

equation
Q = m * Cp * (t2 - t1);
dm = Q / c2;
end Ex4_7;