//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-5: Bernoulli's Equation
//Example: 5.1 Page 134
//Title: Conversion of Potential Energy to Internal Energy
//===================================================================

model Ex5_1

//=============
// Parameter Section 

parameter Real z(unit = "m") = 100 "Height of the waterfall";
parameter Real g(unit = "m/s2") = 9.81 "Acceleration due to gravity";
parameter Real Cv(unit = "J/kg.K") = 4184 "Specific heat capacity of water";

//=============
// Variable Section 

Real u(unit = "J/kg") "Potential Energy";
Real t(unit = "°C") "Temperature change";

//=============
// Equation Section 

equation
u = (- g) * (- z);  //Sign convention
t = u / Cv;


end Ex5_1;