//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-5: Bernoulli's Equation
//Example: 5.11 Page 155
//Title: Rotameter 
//===================================================================

model Ex5_11

//=============
// Parameter Section 

parameter Real q_nitogen(unit = "cm3/min") = 100 "Flowrate of nitrogen";
parameter Real m_nitrogen(unit = "g/mol") = 28 "Molecular weight of nitrogen";
parameter Real m_helium(unit = "g/mol") = 4 "Molecular weight of helium";

//=============
// Variable Section 

Real q_helium(unit = "cm3/min") "Flowrate of helium";

//=============
// Equation Section 

equation
q_helium = q_nitogen * ( m_nitrogen / m_helium) ^ 0.5;

end Ex5_11;