//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-5: Bernoulli's Equation
//Example: 5.12 Page 156
//Title: Siphon draining a tank of water
//===================================================================

model Ex5_12

//=============
// Parameter Section 

parameter Real h1(unit = "ft") = 50 "Height of the tube";
parameter Real h3(unit = "ft") = 10 "Height of the tube from the surface";
parameter Real g(unit = "ft/s2") = 32.2 "Acceleration due to gravity";
parameter Real p1(unit = "psi") = 14.7 "Pressure at point 1";
parameter Real rho(unit = "lbm/ft3") = 62.3 "Density of water";
parameter Real c1(unit = "in2/ft2") = 144 "Conversion of square inch to square foot";
parameter Real c2(unit = "lbm.ft/lbf.s2") = 32.2 "Conversion of lbm.ft to lbf.s2";

//=============
// Variable Section 

Real v2(unit = "ft/s") "Velocity of water in the tube";
Real p2(unit = "psi") "Pressure at point 2";

//=============
// Equation Section 

equation
v2 = ( 2 * g * h3)^0.5;
p2 = p1 - rho * (v2^2/2 + (g * (h1-h3)))/(c1*c2);
end Ex5_12;