//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-5: Bernoulli's Equation
//Example: 5.13 Page 156
//Title: Venturi meter attachd to a tank
//===================================================================

model Ex5_13

//=============
// Parameter Section

parameter Real p1(unit = "psia") = 24.7 "Pressure at point 1 ";
parameter Real p3(unit = "psia") = 14.7 "Pressure at point 3";
parameter Real rho(unit = "lbm/ft3") = 62.3 "Density of water";
parameter Real a(unit = "NA") = 0.5 "Ratio of venturi to outlet areas";
parameter Real c1(unit = "in2/ft2") = 144 "Conversion of square inch to square foot";
parameter Real c2(unit = "lbm.ft/lbf.s2") = 32.2 "Conversion of lbm.ft to lbf.s2";


//=============
// Variable Section

Real p2(unit = "psi") "Pressure at point 2";
Real v2(unit = "ft/s") "Velocity of water at the venturi";
Real v3(unit = "ft/s") "Velocity of water at the outlet";

//=============
// Equation Section

equation
v3 = ( 2 * (p1 - p3) * c1 * c2 / rho) ^ 0.5; 
v2 = v3 / a;
p2 = p1 - (rho * v2^2) / (2 * c1 * c2);
end Ex5_13;