//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-5: Bernoulli's Equation
//Example: 5.14 Page 158
//Title: Tank with nozzle at the bottom
//===================================================================

model Ex5_14

//=============
// Parameter Section

parameter Real h2(unit = "m") = 1 "Final height of the fluid level";
parameter Real h1(unit = "m") = 30 "Initial height of the fluid level";
parameter Real g(unit ="m/s2") = 9.81 "Acceleration due to gravity";
parameter Real d1(unit = "m") = 10 "Diameter of the tank";
parameter Real d2(unit = "m") = 1 "Diameter of the nozzle";

//===============
// Library Section 

extends Modelica.Constants;

//=============
// Variable Section

Real t(unit = "s") "Time taken to drop";

//=============
// Equation Section

equation
t = -2 * ( h2^0.5 - h1^0.5) / (( ( pi * d2^2 / 4) / ( pi * d1^2 / 4)) * (2 * g)^0.5);
end Ex5_14;