//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-5: Bernoulli's Equation
//Example: 5.2 Page 141
//Title: B.E. for Gases
//===================================================================

model Ex5_2

//=============
// Parameter Section 

parameter Real R(unit = "psi.ft3/°R.lbmol") = 10.73 "Gas constant";
parameter Real T(unit = "°R") = 528 "Temperature of the tank";
parameter Real P1(unit = "psi") = 14.71 "Pressure at point 1";
parameter Real M(unit = "lbm/lbmol") = 29 "Molecular weight of air";
parameter Real P_atm(unit = "psi") = 14.7 "Atmospheric pressure";
parameter Real c1(unit = "in2/ft2") = 144 "Conversion factor";
parameter Real c2(unit = "lbm.ft/lbf.s2") = 32.2 "Conversion factor";

//=============
// Variable Section

Real v2(unit = "ft/s") "Velocity at point 2";

//=============
// Equation Section

equation

v2 = ( 2 * R * T * (P1 - P_atm) * c1 * c2 / (P1 * M) )^0.5;  
end Ex5_2;