//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-6: Fluid Friction in Steady, One Dimensional Flow
//Example: 6.1 Page 180
//Title: Fluid Friction in Steady, One Dimensional
//===================================================================

model Ex6_1

//=============
// Parameter Section 

parameter Real Q(unit = "gal/min") = 50 "Volumetric flowrate of oil";
parameter Real D(unit = "in") = 3.068 "Diameter of the pipe";
parameter Real rho(unit  ="lbm/ft3") = 62.3 "Density of the oil";
parameter Real u(unit = "cP") = 50 "Viscosity of the oil";
parameter Real delx(unit = "ft") = 3000 "Length of the pipe";
parameter Real c1(unit = "lbm/ft.s.cP") = 6.72 * 10^(-4) "Conversion factor";
parameter Real c2(unit = "lbf.s/ft2.cP") = 2.09 * 10^(-5) "Conversion factor";
parameter Real c3(unit = "s/min") = 60 "Conversion factor";
parameter Real c4(unit = "in/ft") = 12 "Conversion factor";
parameter Real c5(unit = "in3/gal") = 231 "Conversion factor";
parameter Real c6(unit  = "gal/ft3") = 7.48 "Convrsion factor";
parameter Real c7(unit = "in2/ft2") = 144 "Conversion factor";

//=============
// Library Section

extends Modelica.Constants;

//=============
// Variable Section

Real v_avg(unit = "ft/s") "Average velocity of the oil";
Real R(unit = "NA") "Reynolds number";
Real delp(unit = "lbf/in2") "Gauge pressure required to produce this flowrate";

//=============
// Equation Section

equation
v_avg = Q * c7 / ( (pi/4) * D^2 * c3 * c6 );
R = ( rho * v_avg * D / c4 ) / ( u * c1 );
delp = Q * (128/pi) * u * delx * c5 * c2 / ( D^4 *  c3 * c4 );
end Ex6_1;