//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-6: Fluid Friction in Steady, One Dimensional Flow
//Example: 6.13 Page 207
//Title: Fitting Losses
//===================================================================

model Ex6_13

//=============
// Parameter Section

parameter Real p(unit = "psig") = 100 "Pressure inside the valve";
parameter Real x(unit = "in") = 10^(-4) "Space between seal and valve stem";
parameter Real l(unit = "in") = 1 "Length of the seal in the direction of leakage";
parameter Real d(unit = "in") = 0.25 "Diameter of the valve stem";
parameter Real u(unit = "cP") = 0.6 "Viscosity of the gasoline";
parameter Real c1(unit = "lbf.s/cP.ft2") = 2.09 * 10^(-5) "Conversion factor";
parameter Real c2(unit = "in2/ft2") = 144 "Conversion factor";
parameter Real c3(unit = "s/h") = 3600 "Conversion factor";
parameter Real rho(unit = "lbm/in3") = 0.026 "Density of gasoline";

//=============
// Library Section

extends Modelica.Constants;

//=============
// Variable Section

Real Q(unit = "in3/h") "Volumetric flowrate of gasoline";
Real m(unit = "lbm/h") "Mass flowrate of gasoline"; 

//=============
// Equation Section

equation

Q = p * pi * d * x^3 * c2 * c3 / ( l * u * c1 * 12);
m = Q * rho;

end Ex6_13;