//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-6: Fluid Friction in Steady, One Dimensional Flow
//Example: 6.14 Page 209
//Title: Turbulent Flow in Non-Circular Channels
//===================================================================

model Ex6_14

//=============
// Parameter Section

parameter Real a(unit = "ft2") = 0.5 "Crossectional area of the duct";
parameter Real l(unit = "ft") = 1 "Length of the duct crossectional";
parameter Real b(unit = "ft") = 0.5 "Breadth of the duct crossectional";
parameter Real v(unit = "ft/s") = 40 "Velocity of air in the duct";
parameter Real E(unit = "in") = 10^(-5) "Roughness of the duct";
parameter Real rho(unit = "lbm/ft3") = 0.075 "Density of air";
parameter Real u(unit = "cP") = 0.018 "Viscosity of air";
parameter Real c1(unit = "lbm/ft.s.cP") = 6.72 * 10^(-4) "Conversion factor";
parameter Real c2(unit = "in2/ft2") = 144 "Conversion factor";
parameter Real c3(unit = "lbm.ft/lbf.s2") = 32.2 "Conversion factor";
parameter Real c4(unit = "in/ft") = 12 "Conversion factor";

//=============
// Variable Section

Real HR(unit = "ft") "Hydraulic radius";
Real R(unit = "NA") "Reynolds number";
Real E_D(unit = "NA") "Rougness factor per unit length";
Real delP(unit = "psi/ft") "Pressure drop per unit length";  
Real f(unit = "NA") "Friction factor in the pipe";

//=============
// Equation Section

equation

HR = a / ( 2 * (l+b) );
R = (v * rho * 4 * HR) / (u * c1);
E_D = E / (4* HR);
f = 0.001375  * ( 1 + (20000 * E_D + 10^6/R)^(1/3) );
delP = (f * rho * v^2) / (2 * HR * c2 * c3);

end Ex6_14;