//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-7: The Momentum Balance
//Example: 7.12 Page 267
//Title: Final Velocity of Rocket given Specific Impulse
//===================================================================

model Ex7_16

//=============
// Parameter Section

parameter Real rho(unit = "kg/m3") = 1.21 "Density of the air stream";
parameter Real v_in(unit = "m/s") = 50 "Velocity of the airplane";
parameter Real l(unit = "m") = 15 "Wingspread of the airplane";
parameter Real t(unit = "m") = 3 "Thickness of the wing";
parameter Real F(unit = "N") = 9810 "Loaded mass of the airplane";

//=============
// Variable Section

Real a(unit ="m2") "Area of the wing";
Real m(unit ="kg/s") "Mass flowrate of the air stream";
Real v_out(unit = "m/s") "Average vertical downward vlocity of air";

//=============
// Equation Section

equation
a = l * t;
m = rho * a * v_in;
v_out = F / m;
 
end Ex7_16;