//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-7: The Momentum Balance
//Example: 7.7 Page 255
//Title: Water Travelling in a Pipe 
//===================================================================

model Ex7_7

//=============
// Parameter Section

parameter Real m(unit = "kg/s") = 500 "Mass flowrate of the pipe";
parameter Real a(unit = "m2") = 0.1 "Constant crossectional area of the pipe";
parameter Real p(unit = "Pa") = 200000 "Constant pressure throughout the pipe";
parameter Real rho(unit = "kg/m3") = 998.2 "Density of water";
parameter Real vx_out(unit = "m/s") = 0 "Outlet velocity of water in the x direction";
parameter Real vy_in(unit = "m/s") = 0 "Inlet velocity of water in the y direction"; 

//=============
// Variable Section

Real v(unit = "m/s") "Velocity of water in the pipe";
Real Fx(unit = "N") "Force in the x direction";
Real Fy(unit = "N") "Firce in the y direction";
Real vx_in(unit = "m/s") "Inlet velocity of water in the x direction";
Real vy_out(unit = "m/s") "Outlet velocity of water in the y direction";

//=============
// Equation Section

equation

vx_in = v;
vy_out = - v;
v = (m / rho) / a;
Fx = m * (vx_in - vx_out) + p * a;
Fy = m * (vy_in - vy_out) + p * a;
end Ex7_7;