//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-8: One Dimensional, High Velocity Gas Flow
//Example: 8.3 Page 302
//Title: Steady Frictionless One Dimensional Flow of an Ideal Gas
//===================================================================

model Ex8_3

//=============
// Parameter Section

parameter Real M(unit = "NA") = 2 "Mach Number";
parameter Real k(unit = "NA") = 1.4 "Ratio of specific heats for diatomic gases";
parameter Real T_r(unit = "°R") = 528 "Temperature of air";

//=============
// Variable Section

Real T_1(unit = "°R") "Temperature of gas at a particular point";

//=============
// Equation Section

equation
T_1 = T_r / (M^2 * ((k-1)/2) +1);
end Ex8_3;