//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-8: One Dimensional, High Velocity Gas Flow
//Example: 8.4 Page 302
//Title: Steady Frictionless One Dimensional Flow of an Ideal Gas
//===================================================================

model Ex8_4

//=============
// Parameter Section
parameter Real R(unit = "ft2.lbm/s2.lbmol.°R") = 49729 "Constant R";
parameter Real k(unit = "NA") = 1.4 "Ratio of specific heats";
parameter Real T(unit = "°R") = 293 "Temperature of air";
parameter Real M(unit = "lbm/lbmol") = 29 "Molecular mass of air";
parameter Real M_1(unit = "NA") = 2 "Mach Number";

//=============
// Library Section

extends Modelica.Math;

//=============
// Variable Section

Real c_a(unit = "ft/s") "Speed of sound in air";
Real V_1(unit = "ft/s") "Velocity of air at given Mach number";

//=============
// Equation Section

equation
c_a = sqrt(k * R * T / M);
V_1 = c_a * M_1;

end Ex8_4;