//Noel de Nevers, Fluid Mechanics for Chemical Engineers, 3rd Edn., McGraw Hill Higher Education, 2005

//Chapter-8: One Dimensional, High Velocity Gas Flow
//Example: 8.6 Page 306
//Title: Steady Frictionless One Dimensional Flow of an Ideal Gas
//===================================================================

model Ex8_6

//=============
// Parameter Section

parameter Real T_r(unit = "°R") = 660 "Temperature of the air";
parameter Real v_1(unit = "ft/s") = 1400 "Velocity of gas at a particular point";
parameter Real k(unit = "NA") = 1.4 "Ratio of specific heats";
parameter Real M_w(unit = "lbm/lbmol") = 29 "Molecular mass of gas";
parameter Real R(unit = "ft2.lbm/(s2.lbmol.°R)") = 49729 "Constant R";
parameter Real P_r(unit = "psia") = 30 "Pressure of the air";
parameter Real m(unit = "lbm/s") = 10 "Mass flowrate of air";
parameter Real c_1(unit = "lbm.ft/lbf.s2") = 32.2 "Conversion factor";

//=============
// Library Section

extends Modelica.Math;

//=============
// Variable Section

Real c_a(unit = "ft/s") "Speed of sound in air";
Real Mach(unit = "NA") "Mach number of the gas";
Real T_1(unit = "°R") "Temperature of gas at a particular point";
Real P_1(unit = "psia") "Pressure of air at a particular point";
Real a_star(unit = "in2") "Crossectional area at the point in the duct at critical point";
Real a(unit = "in2") "Crossectional area at the point in the duct";
//=============
// Equation Section

equation
c_a = sqrt(k * R * T_1 / M_w);
Mach = v_1/c_a;
T_1 = T_r - v_1^2 * ((k-1)/k) *(M_w/(2*R));
P_1 = P_r / ((T_r/T_1))^(k/(k-1));
a_star = m / (P_r * (M_w * k)^0.5 * c_1 / (R^0.5  * T_r^0.5 * ((k - 1)/2 + 1)^((k+1)/(2* (k-1)))));
a = a_star * ((Mach^2 * (k - 1)/2 + 1) / ( (k - 1)/2 +1 ) )^( (k +1)/(2 * (k-1))) * (1 / Mach);
end Ex8_6;