//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-10: Computer-Aided Balance Calculations
//Example: 10.3-2 Page 524
//Title: Simulation of an Equilibrium Reaction/Separation Process
//===================================================================
model Ex10_3_2
    //=============
    // Parameter Section
    parameter Real nf (unit = "mol C2H6") = 100 "Moles of C2H6 entering the reactor";
                    
    //=============
    // Variable Section
    Real n0 (unit = "mol C2H6") "Moles of fresh C2H6 fed to reactor";
    Real n1 (unit = "mol C2H6") "Moles of C2H6 leaving reactor";
    Real n2 (unit = "mol C2H4") "Moles of C2H4 leaving reactor";
    Real n3 (unit = "mol C2H2") "Moles of C2H2 leaving reactor";
    Real n4 (unit = "mol H2") "Moles of H2 leaving reactor";
    Real n5 (unit = "mol C2H6") "Moles of C2H6 leaving separator";
    Real n6 (unit = "mol C2H6") "Moles of C2H6 recycled";
    Real ntot (unit = "mol") "Total number of moles leaving reactor";
    Real epsilon1 (unit = "mol", start = 10) "Extent of 1st reaction";
    Real epsilon2 (unit = "mol", start = 10) "Extent of 2nd reaction";
     
    //=============
    // Equation Section
    equation
        n0 + n6 = nf; // Balance at recycle mix point
        n1 = nf - epsilon1 - epsilon2;
        n2 = epsilon1;
        n3 = epsilon2;
        n4 = epsilon1 + 2 * epsilon2;
        ntot =n1 + n2 + n3 + n4;
        epsilon1* (epsilon1 + 2 * epsilon2) / (nf - epsilon1 - epsilon2) / (nf + epsilon1 + 2* epsilon2) = 3.75;
        epsilon2* (epsilon1 + 2 * epsilon2)^2 / (nf - epsilon1 - epsilon2) / (nf + epsilon1 + 2* epsilon2)^2 = 0.135;
        n5 = 0.05 * n1; //Split of C2H6 at separator
        n1 = n5 + n6; //C2H6 balance 
                                
end Ex10_3_2;                
//===================================================================