//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-11: Balances on Transient Processes
//Example: 11.2-2 Page 552
//Title: Transient behaviour of a stirred tank reactor
//===================================================================
//Set simulation time 400 or above
model Ex11_2_2
    //=============
    // Parameter Section
    parameter Real V_in (unit = "L/s") = 0.15 "Inlet volumetric flow rate";
    parameter Real V_out (unit = "L/s") = 0.15 "Outlet volumetric flow rate";
    parameter Real CA_in (unit = "mol A/ L") = 10 "Inlet concentration of A";
    parameter Real V (unit = "L") = 10 "Volume of reactor";
    
    //=============
    // Variable Section
    Real CA (unit = "mol/L", start = 2) "Concentration of A in tank and outlet";
    Real ip (unit = "mol/s") "Input concentration";
    Real op (unit = "mol/s") "Input concentration";    
    Real gen (unit = "mol/s") "Generation of A";
    Real cons (unit = "mol/s") "Consumption of A";
    Real CAs (unit = "mol/L") "Steady state concentration";
        
    //=============
    // Equation Section 
    equation
        ip = CA_in * V_in;
        op = CA * V_out;
        gen = 0;
        cons = V * 0.005 * CA;
        0.150 - 0.02*CAs = 0;
        der(CA) * V= ip - op - cons + gen;
                         
end Ex11_2_2;
//===================================================================