//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-11: Balances on Transient Processes
//Example: 11.3-1 Page 556
//Title: Startup of a batch reactor
//===================================================================
model Ex11_3_1
    //=============
    // Parameter Section
    parameter Real Qdot (unit = "W") = 500 "Heating rate";
    parameter Real M_reactor (unit = "kg") = 3 "Mass of reactor";
    parameter Real M_reactants (unit = "kg") = 1.5 "Mass of reactants";
    parameter Real Cv_reactor (unit = "cal/g degC") = 0.120 "Specific heat capacity of reactor";
    parameter Real Cv_reactants (unit = "cal/g degC") = 0.900 "Specific heat capacity of reactants";
    parameter Real T_i (unit = "degC") = 25 "Initial temperature";
    parameter Real T_f (unit = "degC") = 250 "Final temperature";
    
    //=============
    // Variable Section
    Real tf (unit = "min") "Time required";
    Real MCv (unit = "J/degC") "Heat capacity of sustem";
            
    //=============
    // Equation Section 
    equation
        MCv = (M_reactor * 1000 * Cv_reactor + M_reactants * 1000 * Cv_reactants) * 4.184;
        MCv * (T_f - T_i) = Qdot * (tf*60);
                         
end Ex11_3_1;
//===================================================================