//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-2: Introduction to Engineering Calculations
//Example: 2.7-2 Page 26
//Title: Linear Curve-Fitting of Nonlinear Data
//===================================================================
model Ex2_7_2
    //=============
    // Parameter Section 
    parameter Real [4] T(each unit="deg C" ) = {10, 20, 40, 80} "Given temperature data points";
    parameter Real [4] m_dot(each unit="g/s" ) = {14.76, 20.14, 27.73, 38.47} "Given mass flow rate data points";
    
    //=============
    // Variable Section 
    Real [4] root_T(each unit="degC^0.5" ) "Square root of given temperature data points";
    Real a (unit="g/s degC^0.5") "Slope of the line";
    Real b (unit="g/s") "Intercept of the line";
    
    //=============
    // Algorithm Section 
    algorithm
      for i in 1:4 loop
        root_T[i]:=T[i]^0.5;
      end for;
    
    //=============
    // Equation  Section 
    equation
      a = (m_dot[4] - m_dot[1]) / (root_T[4] - root_T[1]); //The first and last points lie on the line
      b = m_dot[1] - (a * root_T[1]);
      
end Ex2_7_2;
//===================================================================