//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-2: Introduction to Engineering Calculations
//Example: 2.7-3 Page 29
//Title: Curve Fitting on Semilog and Log Plots
//===================================================================
package Ex2_7_3
    //=============
    //Semilog Plot calculations
    model Ex2_7_3_1
    //=============
      // Parameter Section 
      parameter Real t1 = 15;
      parameter Real t2 = 30;
      parameter Real F1 = 0.298;
      parameter Real F2 = 0.0527;
      
      //=============
      // Variable Section 
      Real a "Slope";
      Real b "Intercept";
      
      //=============
      // Equation  Section 
      equation
        b = log(F2/F1)/(t2-t1);
        log(a) = log(F1)- b*t1;
    end Ex2_7_3_1;
    //=============
    
    //Log plot calculations
    model Ex2_7_3_2
    //=============
      // Parameter Section 
      parameter Real t1 = 15;
      parameter Real t2 = 30;
      parameter Real F1 = 0.298;
      parameter Real F2 = 0.0527;
      
      //=============
      // Variable Section 
      Real a "Slope";
      Real b "Intercept";
      
      //=============
      // Equation  Section 
      equation
        b = log(F2/F1)/ log(t2/t1);
        log(a) = log(F1)- b*log(t1);
    end Ex2_7_3_2;
    //=============

end Ex2_7_3;
//===================================================================
