//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-3: Processes and Process Variables
//Example: 3.1-1 Page 44
//Title: Mass, Volume, Density
//===================================================================
model Ex3_1_1
    //=============
    // Parameter Section 
    parameter Real sp_grav = 13.546 "Specific gravity of Mercury at 20 degC from Table B. 1";
    parameter Real mass (unit="kg") = 215 "Mass of mercury";
    
    //=============
    // Variable Section 
    Real Density (unit="lb /ft^3");
    Real volume (unit="ft^3");
    
    //=============
    // Equation  Section 
    equation
       Density = sp_grav * 62.43; //Multiplied by density of water at 20 degC
       volume = mass / 0.454 / Density; //Dividing by 0.454 to convert mass from kg to lb

end Ex3_1_1;
//===================================================================