//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-3: Processes and Process Variables
//Example: 3.1-2 Page 45
//Title: Effect of Temperature on Density
//===================================================================
model Ex3_1_2
    //=============
    // Parameter Section 
    parameter Real V20 (unit = "ft^3") = 0.560 "Volume occupied by given mass of mercury at 20 degC";
    parameter Real m (unit = "kg") = 215 "Mass of mercury";
    parameter Real D (unit = "in") = 0.25 "Diameter of cylinder";
    import Modelica.Constants.pi;
    
    //=============
    // Variable Section 
    Real V100 (unit = "ft^3") "Volume occupied by given mercury at 100 degC";
    Real H (unit = "ft") "Change in height of mercury";
    Real V0 (unit = "ft^3") "Volume occupied by mercury at 0 degC";
    
    //=============
    // Equation  Section 
    equation
        V100 = V0 * (1 + 0.18182e-3 * 100 + 0.0078e-6 * 100^2);
        V20 = V0 * (1 + 0.18182e-3 * 20 + 0.0078e-6 * 20^2);
        H = (V100 - V20) / (pi * (D/12)^2 /4);
    
    
end Ex3_1_2;
//===================================================================