//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000

//Chapter-3: Processes and Process Variables
//Example: 3.3-2 Page 50
//Title: Conversion using mass and mole fractions
//===================================================================
package Ex3_3_2

    model Ex3_3_2_1
        //=============
        // Parameter Section 
        parameter Real xA = 0.15 "Mass fraction of A";
        parameter Real yB = 0.20 "Mole fraction of B";
        parameter Real m_sol (unit="kg") = 175 "Mass of solution";
        
        //=============
        // Variable Section 
        Real m_A (unit = "kg") "Mass of A in solution";
        
        //=============
        // Equation  Section 
        equation
           m_A = m_sol * xA;
        
    end Ex3_3_2_1;
    //===================================================================
    
    model Ex3_3_2_2
        //=============
        // Parameter Section 
        parameter Real xA = 0.15 "Mass fraction of A";
        parameter Real yB = 0.20 "Mole fraction of B";
        parameter Real flow_sol (unit="lb/h") = 53 "Mass flow rate of solution";
        
        //=============
        // Variable Section 
        Real flow_A (unit = "lb A/h") "Mass flow rate of A in solution";
        
        //=============
        // Equation  Section 
        equation
           flow_A = flow_sol * xA;
        
    end Ex3_3_2_2;
    //===================================================================
    
    model Ex3_3_2_3
        //=============
        // Parameter Section 
        parameter Real xA = 0.15 "Mass fraction of A";
        parameter Real yB = 0.20 "Mole fraction of B";
        parameter Real m_flow_sol (unit="mol /min") = 1000 "Molar flow rate of solution";
        
        //=============
        // Variable Section 
        Real m_flow_B (unit="mol B/min") "Molar flow rate of solution";
        
        //=============
        // Equation  Section 
        equation
           m_flow_B = m_flow_sol * yB;
        
    end Ex3_3_2_3;
    //===================================================================
    
    model Ex3_3_2_4
        //=============
        // Parameter Section 
        parameter Real xA = 0.15 "Mass fraction of A";
        parameter Real yB = 0.20 "Mole fraction of B";
        parameter Real m_flow_B (unit="kmol B/s") = 28 "Molar flow rate of solution";
        
        //=============
        // Variable Section 
        Real m_flow_sol (unit="kmol /s") "Molar flow rate of solution";
        
        //=============
        // Equation  Section 
        equation
           m_flow_B = m_flow_sol * yB;
        
    end Ex3_3_2_4;
    //===================================================================
    
    model Ex3_3_2_5
        //=============
        // Parameter Section 
        parameter Real xA = 0.15 "Mass fraction of A";
        parameter Real yB = 0.20 "Mole fraction of B";
        parameter Real m_A (unit="lb A") = 300 "Mass of A in solution";
        
        //=============
        // Variable Section 
        Real m_sol (unit="lb") "Mass of solution";
        
        //=============
        // Equation  Section 
        equation
          m_A = m_sol * xA;
          
    end Ex3_3_2_5;
    //===================================================================

end Ex3_3_2;
