//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-4: Fundamentals of Material Balances
//Example: 4.2-1 Page 85
//Title: The General Balance Equation
//===================================================================
model Ex4_2_1
//=============
// Parameter Section 
parameter Real I (unit = "P/yr") = 50000 "Number of people moving into the city per year";
parameter Real O (unit = "P/yr") = 75000 "Number of people moving out of the city per year";
parameter Real G (unit = "P/yr") = 22000 "Number of people born in the city per year";
parameter Real C (unit = "P/yr") = 19000 "Number of people dying in the city per year";

//=============
// Variable Section 
Real A (unit = "P/yr") "Net change in the population of the city per year";

//=============
// Equation  Section 
equation
  A = I + G - O - C;

end Ex4_2_1;