//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-4: Fundamentals of Material Balances
//Example: 4.2-4 Page 88
//Title: Integral balance on a semibatch Process
//===================================================================
model Ex4_2_4
//=============
// Parameter Section 
parameter Real n_dot_a (unit="kmol / min") = 0.1 "Molar flow rate of air";
parameter Real sp_g_h = 0.659 "Specific gravity of liquid hexane"; //From Table B.1 in Felder and Rousseau
parameter Real v (unit="m^3") = 10 "Volume of hexane to be vapourised";
parameter Real y_h = 0.1 "Mole fraction of hexane in leaving air";
parameter Real mw_h = 86.2 "Molar weight of hexane";

//=============
// Variable Section 
Real n_dot (unit = "kmol/min") "Molar flow rate of exit gas";
Real tf (unit = "min") "Time required to vapourise the entire volume of hexane";
Real del_n (unit = "kmol") "Change in moles of hexane in the vessel";

//=============
// Equation  Section 
equation
  n_dot_a = n_dot * (1 - y_h);
  del_n = -v * sp_g_h * 10^3 / mw_h;
  del_n = -y_h * n_dot * tf;
  
end Ex4_2_4;