//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-4: Fundamentals of Material Balances
//Example: 4.3-4 Page 100
//Title: Degrees of Freedom Analysis
//===================================================================
model Ex4_3_4
		//=============
		// Parameter Section 
		parameter Real unknown = 5 "Number of unknowns in the problem";
		parameter Real eqn = 5 "Number of equations that can be formed";
		parameter Real v_c (unit="l") = 225 "Volumetric rate of condensation of water";
		parameter Real x_O2 = 0.21 "Mole fraction of oxygen in dry air";
		parameter Real x_N2 = 0.79 "Mole fraction of nitrogen in dry air";
		parameter Real x_H2O = 0.10 "Mole fraction of water in inlet on wet basis";
		//=============
		// Variable Section 		
		Real n1 (unit = "mol/h") "Molar flow rate of inlet air";
		Real n2 (unit = "mol/h") "Molar flow rate of condensed water";
		Real n3 (unit = "mol/h") "Molar flow rate of oxygen in outlet gas";
		Real n4 (unit = "mol/h") "Molar flow rate of nitrogen in outlet gas";
		Real n5 (unit = "mol/h") "Molar flow rate of water in outlet gas";
		Real ntotal (unit = "mol/h") "Total molar flow rate of outlet gas";
		//=============
		// Equation Section 
		equation
				n2 = v_c * 1 / 18; //Molar rate = Volume rate * desity / molar mass
				n2 = 0.95 * n1 * x_H2O; //Given that 95% condensation occurs
				n1 * (1 - x_H2O) * x_O2 = n3; //Oxygen balance
				n1 * (1 - x_H2O) * x_N2 = n4; //Nitrogen balance
				n1 * x_H2O = n2 + n5; //Water balance, equation given in the textbook is incorrect
				ntotal = n3 + n4 + n5;
end Ex4_3_4;
//===================================================================