//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-4: Fundamentals of Material Balances
//Example: 4.5-2 Page 112
//Title: An Evaporative Crystallisation Process
//===================================================================
package Ex4_5_2
    model Ex4_5_2_1
        //=============
        // Parameter Section
        parameter Real mF (unit = "kg/h") = 4500 "Mass flow rate of feed";
        parameter Real xF (unit = "kg K/ kg") = 0.333 "Mass fraction of potassium dichromate in feed";
        parameter Real x3 (unit = "kg K/ kg") = 0.494 "Mass fraction of potassium dichromate in concentrated solution";
        parameter Real x5 (unit = "kg K/ kg") = 0.364 "Mass fraction of potassium dichromate in filter cake";
       
        //=============
        // Variable Section 		
        Real m1 (unit = "kg/h")  "Mass flow of mixed stream";
        Real m2 (unit = "kg/h") "Mass flow of evaporated stream";
        Real m3 (unit = "kg/h") "Mass flow rate of concentrated solution";
        Real m4 (unit = "kg/h") "Mass flow rate of K2Cr2O7 in filter cake";
        Real m6 (unit = "kg/h") "Mass flow rate of filtrate recycle stream";
        Real m5 (unit = "kg/h") "Mass flow rate of solution from filter";
        
        //=============
        // Equation Section 
        equation
            m4 = 0.95 * (m4 + m5);
            xF * mF = m4 + x5*m5; //K2Cr2O7 balance
            mF = m2 + m4 + m5; //Overall mass balance 
            m3 = m4 + m5 + m6; //Mass balance for crystalliser
            (1-x3) * m3 = (1-x5) * m5 + (1-x5) * m6; //Water balance in crystalliser
            mF + m6 = m1; //Mass balance around mix point
                    
    end Ex4_5_2_1;
    //===================================================================
    
    model Ex4_5_2_2
        //=============
        // Parameter Section
        parameter Real mF (unit = "kg/h") = 4500 "Mass flow rate of feed";
        parameter Real xF (unit = "kg K/ kg") = 0.333 "Mass fraction of potassium dichromate in feed";
        parameter Real x2 (unit = "kg K/ kg") = 0.494 "Mass fraction of potassium dichromate in concentrated solution";
        parameter Real x4 (unit = "kg K/ kg") = 0.364 "Mass fraction of potassium dichromate in filtrate";
       
        //=============
        // Variable Section 		
        Real m1 (unit = "kg/h") "Mass flow of evaporated stream";
        Real m2 (unit = "kg/h") "Mass flow rate of concentrated solution";
        Real m3 (unit = "kg/h") "Mass flow rate of K2Cr2O7 in filter cake";
        Real m4 (unit = "kg/h") "Mass flow rate of filtrate";
        Real m5 (unit = "kg/h") "Mass flow rate of solution from filter";
        
        //=============
        // Equation Section 
        equation
            mF = m1 + m2; //Balance for evaporator
            m2 = m4 + m3 + m5; // Mass balance for crystalliser and filter
            mF * (1-xF) = m2 * (1-x2) + m1; //Water balance for evaporator
            m2 * x2 = m3 + m4 * x4 + m5 * x4; //K2Cr2O7 balance for crystalliser and filter
            m3  = 0.95 * (m3  + m4);
            
    end Ex4_5_2_2;
    //===================================================================
    
end Ex4_5_2;
