//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-5: Single phase systems
//Example: 5.1-1 Page 190
//Title: Determination of solution density
//===================================================================
model Ex5_1_1
    //=============
    // Parameter Section
    parameter Real ro_H2O_20 (unit = "g/cm^3") = 0.998 "Density of water at 20 deg C";
    parameter Real ro_H2SO4_18 (unit = "g/cm^3") = 1.834 "Density of H2SO4 at 18 deg C";
    parameter Real x_H2SO4 = 0.5 "Mass fraction of sulphuric acid in solution";
   
    //=============
    // Variable Section 		
    Real ro_bar_1 (unit = "g/cm^3") "Density of solution calculated by volume additivity";
    Real ro_bar_2 (unit = "g/cm^3") "Density of solution calculated by weighted average using mass fraction";
    
    //=============
    // Equation Section 
    equation
    //Density change in H2SO4 due to thermal expansion are neglected
        (1/ro_bar_1) = (x_H2SO4 / ro_H2SO4_18) + ((1-x_H2SO4) / ro_H2O_20);
        ro_bar_2 = (x_H2SO4 * ro_H2SO4_18) + ((1-x_H2SO4) * ro_H2O_20);
        
end Ex5_1_1;
//===================================================================