//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-5: Single phase systems
//Example: 5.2-2 Page 195
//Title: Conversion from Standard Conditions
//===================================================================
model Ex5_2_2
    //=============
    // Parameter Section
    parameter Real m_dot (unit = "kg/h") = 1100 "Mass flow rate of butane";
    parameter Real T_c (unit = "degC") = 360 "Temperature of butane";
    parameter Real P (unit = "atm") = 3 "Pressure of butane";
    parameter Real M (unit = "g/mol") = 58.1 "Molar mass of butane";
    parameter Real Ts (unit = "K") = 273 "Reference temperature";
    parameter Real Ps (unit = "atm") = 1 "Reference pressure";
    parameter Real Vs (unit = "m^3/kmol") = 22.4  "Molar volume of ideal gas at STP";
    
    //=============
    // Variable Section
    Real T (unit = "K") "Temperature in Kelvin";
    Real n_dot (unit = "mol/h") "Molar flow rate";
    Real V_dot (unit = "m^3/h") "Volumetric flow rate";    
    
    //=============
    // Equation Section 
    equation
        T = T_c + 273; //Conversion of temperature from degC to K
        n_dot = m_dot / M; //Calculation of molar flow rate
        V_dot = n_dot * Vs * T / Ts * Ps / P;
        
end Ex5_2_2;
//===================================================================