//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-5: Single phase systems
//Example: 5.2-5 Page 198
//Title: Material Balances on an Evaporator -Compressor
//===================================================================
model Ex5_2_5
    //=============
    // Parameter Section
    parameter Real T1 (unit = "degC") = 27 "Temperature of Nitrogen fed to evaporator";
    parameter Real P1_gauge (unit = "mmHg") = 475 "Gauge pressure of Nitrogen fed to evaporator";
    parameter Real V2_dot (unit = "L/min") = 400 "Volumetric flow rate of acetone fed to evaporator";
    parameter Real V3_dot (unit = "m^3/min") = 419 "Volumetric flow rate of Nitrogen fed before compressor";
    parameter Real Ts (unit = "K") = 273 "Standard temperature";
    parameter Real P_atm (unit = "mmHg") = 760 "Atmospheric pressure";
    parameter Real Ps (unit = "mmHg") = 760 "Standard pressure";
    parameter Real Vs (unit = "m^3/mol") = 0.0224 "Molar volume of ideal gas at STP";
    parameter Real pa (unit = "mmHg") = 501 "Vapour pressure of acetone at 325 degC";
    parameter Real M_a (unit = "g/mol") = 58.08 "Molar mass of acetone";
    parameter Real ro (unit = "g/L") = 791 "Density of acetone"; //From table B.1 Appendix B
    parameter Real P_gauge (unit = "atm g") = 6.3 "Gauge pressure of compressor outlet mixture";
    parameter Real T4 (unit = "deg C") = 325 "Temperature of compressor outlet mixture";
    
    //=============
    // Variable Section
    Real V1_dot (unit = "m^3/min") "Volumetric flow rate of Nitrogen fed to evaporator";
    Real n1_dot (unit = "mol/min") "Molar flow rate of Nitrogen fed to evaporator";
    Real n2_dot (unit = "mol/min") "Molar flow rate of acetone fed to evaporator";
    Real n3_dot (unit = "mol/min") "Molar flow rate of Nitrogen fed before compressor";
    Real n4_dot (unit = "mol/min") "Molar flow rate of compressor outlet mixture";
    Real y4 (unit = "mol/min") "Mole fraction of acetone in compressor outlet mixture";
    Real P (unit = "mmHg") "Absolute pressure of compressor outlet mixture";
    Real P1 (unit = "mmHg") "Absolute pressure of Nitrogen fed to evaporator";
    
    //=============
    // Equation Section 
    equation
        n2_dot = V2_dot * ro / M_a;
        y4 = pa / P;
        P1 = P1_gauge + P_atm;
        P = (P_gauge * 760) + P_atm; //Multiplying by 760 to convert from atm to mmHg
        n3_dot = V3_dot / Vs;
        n2_dot = n4_dot * y4;
        n1_dot + n2_dot + n3_dot = n4_dot; //Mass balance
        V1_dot = n1_dot * Vs * (T1+273) / Ts * Ps / P1;
        
end Ex5_2_5;
//===================================================================