//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-5: Single phase systems
//Example: 5.3-1 Page 202
//Title: The Truncated Virial Equation
//===================================================================
model Ex5_3_1
    //Answer differs from text book answer due to rounding off of T in textbook
    //=============
    // Parameter Section
    parameter Real T_c (unit = "degC") = -150.8 "Temperature of Nitrogen in degree Celsius";
    parameter Real n (unit = "mol") = 2 "Moles of Nitrogen";
    parameter Real V (unit = "L") = 3 "Volume of Nitrogen";
    parameter Real R (unit = "Latm/molK") = 0.08206 "Gas constant";
    parameter Real Tc_N2 (unit ="K") = 126.2 "Critical temperature of N2 at given conditions"; //Taken from Table B.1
    parameter Real Pc_N2 (unit ="atm") = 33.5"Critical pressure of N2 at given conditions"; //Taken from Table B.1
    parameter Real w_N2 = 0.04 "Acentric factor for N2"; //From Table 5.3-1
    
    //=============
    // Variable Section
    Real T (unit = "K") "Temperature of Nitrogen in Kelvin";
    Real V_cap (unit = "L/mol") "Molar volume of nitrogen";
    Real P_ideal (unit = "atm") "Ideal gas pressure at given conditions";
    Real Tr "Reduced pressure of N2";
    Real B0;
    Real B1;
    Real B "First virial coefficient";
    Real P (unit = "atm") "Pressure of the tank";
    Real epsilon "Error in pressure calculated by ideal gas equation of state";
    
    //=============
    // Equation Section 
    equation
        T = T_c + 273.2;
        V_cap = V / n;
        P_ideal = R*T/V_cap;
        Tr = T/ Tc_N2;
        B0 = 0.083 - (0.422 / Tr ^1.6);
        B1 = 0.139 - (0.172 / Tr ^4.2);
        B = R * Tc_N2 / Pc_N2 * (B0 + (B1*w_N2));
        P = R * T / V_cap * (1 + (B/V_cap));
        epsilon = (P_ideal - P) / P *100;
            
end Ex5_3_1;
//===================================================================