//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-5: Single phase systems
//Example: 5.3-2 Page 203
//Title: The SRK Equation of State
//===================================================================
model Ex5_3_2
    //=============
    // Parameter Section
    parameter Real T (unit = "K") =  300 "Temperature of CO2 in Kelvin";
    parameter Real n (unit = "kmol") = 1 "Moles of CO2";
    parameter Real V (unit = "m^3") = 2.5 "Volume of CO2";
    parameter Real R (unit = "Latm/molK") = 0.08206 "Gas constant";
    parameter Real Tc_CO2 (unit ="K") = 304.2 "Critical temperature of CO2 at given conditions"; //Taken from Table B.1
    parameter Real Pc_CO2 (unit ="atm") = 72.9 "Critical pressure of CO2 at given conditions"; //Taken from Table B.1
    parameter Real w_CO2 = 0.225 "Acentric factor for CO2"; //From Table 5.3-1
    
    //=============
    // Variable Section
    Real V_cap (unit = "L/mol") "Molar volume of nitrogen";
    Real a (unit = "L^2 atm / mol^2") "SRK constant 1";
    Real b (unit = "L / mol") "SRK constant 2";
    Real Tr "Reduced temperature of CO2";
    Real m;
    Real alpha;
    Real P (unit = "atm") "Pressure of the tank";
    
    //=============
    // Equation Section 
    equation
        V_cap = V / n;
        a = 0.42747 * (R * Tc_CO2)^2 / Pc_CO2;
        b = 0.08664 * R * Tc_CO2 / Pc_CO2;
        Tr = T/ Tc_CO2;
        m= 0.48508 + (1.55171*w_CO2) - (0.1561*w_CO2^2);
        alpha = (1+m*(1-Tr^0.5))^2;
        P = (R*T/(V_cap - b)) - (alpha*a/V_cap/(V_cap+b));
    
end Ex5_3_2;
//===================================================================