//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-5: Single phase systems
//Example: 5.4-2 Page 209
//Title: The Generalised Compressibility Chart
//===================================================================
model Ex5_4_2
    //=============
    // Parameter Section
    parameter Real T_C (unit = "degC") =  -20.6 "Temperature of N2 in degree Celsius";
    parameter Real n (unit = "mol") = 100 "Moles of N2";
    parameter Real V (unit = "L") = 5 "Volume of N2 vessel";
    parameter Real R (unit = "Latm/molK") = 0.08206 "Gas constant";
    parameter Real Tc (unit ="K") = 304.2 "Critical temperature of N2 at given conditions"; //Taken from Table B.1
    parameter Real Pc (unit ="atm") = 72.9 "Critical pressure of N2 at given conditions"; //Taken from Table B.1
    parameter Real z = 1.77 "Compressibility of N2 at Tc and Vc"; //From Figure 5.4-4 Pg 211    
    
    //=============
    // Variable Section
    Real V_cap (unit = "L/mol") "Molar volume of N2";
    Real T (unit = "K") "Temperature of N2 in Kelvin";
    Real P (unit = "atm") "Pressure of the tank";
    Real Tr "Reduced temeperature of N2";
    Real V_r_ideal "Reduced volume of N2";
    
    //=============
    // Equation Section 
    equation
        V_cap = V/n;
        T = T_C + 273.15;
        Tr = T/Tc;
        V_r_ideal = V_cap * Pc / R / Tc;
        P = z * R * T / V_cap;
        
end Ex5_4_2;
//===================================================================