//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-6: Multiphase Systems
//Example: 6.1-1 Page 244
//Title: Vapour Pressure Estimation Using Clausius-Clapeyron Equation
//===================================================================
model Ex6_1_1
    //=============
    // Parameter Section
    parameter Real T1_c (unit="degC") = 7.6 "Temperature 1 in degree Celsius";
    parameter Real T2_c (unit="degC") = 15.4 "Temperature 2 in degree Celsius";
    parameter Real p1_star (unit="mmHg") = 40 "Vapour pressure of benzene at temperature T1";
    parameter Real p2_star (unit="mmHg") = 60 "Vapour pressure of benzene at temperature T2";
    parameter Real T_c (unit="degC") = 42.2 "Temperature 3 in degree Celsius";
    parameter Real R (unit = "J/molK") = 8.314 "Gas constant";
    //=============
    // Variable Section 	
    Real T1 (unit="K") "Temperature 1 in Kelvin";
    Real T2 (unit="K") "Temperature 2 in Kelvin";	
    Real T (unit="K") "Temperature 3 in Kelvin";	
    Real delH_cap_v (unit = "J/mol") "Latent heat of vapourisation of benzene";
    Real B "Parameter in Clausius-Clapeyron Equation";
    Real p_star (unit = "mmHg") "Vapour pressure of benzene at temperature T";
    
    //=============
    // Equation Section 
    equation
        T = T_c + 273.15;
        T2 = T2_c + 273.15;
        T1 = T1_c + 273.15;
        (delH_cap_v / R) = - log(p1_star/p2_star)/((1/T1) - (1/T2));
        B = log(p1_star) + (delH_cap_v/(R*T1));
        log(p_star) = B - (delH_cap_v/(R*T));
                
end Ex6_1_1;
//===================================================================