//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-6: Multiphase Systems
//Example: 6.3-1 Page 250
//Title: Composition of a Saturated Gas-Vapor System
//===================================================================
model Ex6_3_1
    //=============
    // Parameter Section
    parameter Real p_star_H2O_75 (unit = "mmHg") = 289 "Pure component vapour pressure of watre at 75 degC"; // From Table B.3 Appendix B
    parameter Real P (unit = "mmHg") = 760 "Pressure of the closed chamber";
    
    //=============
    // Variable Section 	
    Real y_H2O "Mole fraction of H2O in vapour phase";
    Real y_dryair "Mole fraction of dry air in vapour phase";
        
    //=============
    // Equation Section 
    equation
        y_H2O = p_star_H2O_75 / P; //Raoult's Law
        y_dryair = 1 - y_H2O;
                
end Ex6_3_1;
//===================================================================