//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-6: Multiphase Systems
//Example: 6.4-3 Page 260
//Title: Bubble and Dew Point Calculations
//===================================================================
package Ex6_4_3
    model Ex6_4_3_1
    //=============
    // Parameter Section
    parameter Real P_atm (unit = "atm") = 1 "System pressure in atm";
    parameter Real xA = 0.4 "Liquid phase mole fraction of benzene";
    parameter Real xB = 0.6 "Liquid phase mole fraction of toluene";
    
    //=============
    // Variable Section 	
    Real pA_star (unit = "mmHg") "Vapour Pressure of benzene";
    Real pB_star (unit = "mmHg") "Vapour Pressure of toluene";
    Real P (unit = "mmHg") "System pressure in mmHg";
    Real Tbp (unit = "degC") "Bubble point temperature";
    Real yA (unit = "mole Benzene / mol") "Vapour phase benzene mole fraction";
    Real yB (unit = "mole toluene / mol") "Vapour phase toluene mole fraction";
    Real pA (unit = "mmHg") "Partial Pressure of benzene";
    Real pB (unit = "mmHg") "Partial Pressure of toluene";
    
    //=============
    // Equation Section 
    equation
        P = P_atm *760;    
        log10(pA_star) = 6.89272 - (1203.531 / (Tbp+ 219.888)); //Antoine Equation constants From Table B.4
        log10(pB_star) = 6.95805 - (1346.773 / (Tbp + 219.693)); //From Table B.4
        P = xA * pA_star + xB * pB_star;
        pA = xA*pA_star;
        pB = xB*pB_star;
        yA = pA/P;
        yB = pB/P;
        
    end Ex6_4_3_1;
    //===================================================================
    
    model Ex6_4_3_2
    //=============
    // Parameter Section
    parameter Real P_atm (unit = "atm") = 1 "System pressure in atm";
    parameter Real yA = 0.1 "Vapour phase mole fraction of benzene";
    parameter Real yB = 0.1 "Vapour phase mole fraction of toluene";
    
    //=============
    // Variable Section 	
    Real pA_star (unit = "mmHg") "Vapour Pressure of benzene";
    Real pB_star (unit = "mmHg") "Vapour Pressure of toluene";
    Real P (unit = "mmHg") "System pressure in mmHg";
    Real Tdp (unit = "degC") "Dew point temperature";
    Real xA (unit = "mole Benzene / mol") "Liquid phase benzene mole fraction";
    Real xB (unit = "mole toluene / mol") "Liquid phase toluene mole fraction";
    Real pA (unit = "mmHg") "Partial Pressure of benzene";
    Real pB (unit = "mmHg") "Partial Pressure of toluene";
    
    //=============
    // Equation Section 
    equation
        P = P_atm *760;    
        log10(pA_star) = 6.89272 - (1203.531 / (Tdp+ 219.888)); //Antoine Equation constants From Table B.4
        log10(pB_star) = 6.95805 - (1346.773 / (Tdp + 219.693)); //From Table B.4
        1/P = (yA / pA_star) + (yB / pB_star);
        yA = pA/P;
        yB = pB/P;
        pA = xA*pA_star;
        pB = xB*pB_star;
        
    end Ex6_4_3_2;
    //===================================================================
    
    model Ex6_4_3_3
    //=============
    // Parameter Section
    parameter Real yA = 0.15 "Vapour phase mole fraction of benzene";
    parameter Real yB = 0.1 "Vapour phase mole fraction of toluene";
    parameter Real T (unit = "degC") = 80"System temperature";
    
    //=============
    // Variable Section 	
    Real pA_star (unit = "mmHg") "Vapour Pressure of benzene";
    Real pB_star (unit = "mmHg") "Vapour Pressure of toluene";
    Real P (unit = "mmHg") "System pressure in mmHg when condensation occurs";
    Real xA (unit = "mole Benzene / mol") "Liquid phase benzene mole fraction";
    Real xB (unit = "mole toluene / mol") "Liquid phase toluene mole fraction";
    Real pA (unit = "mmHg") "Partial Pressure of benzene";
    Real pB (unit = "mmHg") "Partial Pressure of toluene";
    
    //=============
    // Equation Section 
    equation
        log10(pA_star) = 6.89272 - (1203.531 / (T+ 219.888)); //Antoine Equation constants From Table B.4
        log10(pB_star) = 6.95805 - (1346.773 / (T + 219.693)); //From Table B.4
        1/P = (yA / pA_star) + (yB / pB_star);
        yA = pA/P;
        yB = pB/P;
        pA = xA*pA_star;
        pB = xB*pB_star;
        
    end Ex6_4_3_3;
    //===================================================================
    
end Ex6_4_3;
