//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-6: Multiphase Systems
//Example: 6.5-2 Page 266
//Title: Material balances on a crystalliser
//===================================================================
model Ex6_5_2
    //=============
    // Parameter Section
    parameter Real m (unit = "kg") = 100 "Mass of KNO3 solution fed to crystalliser";
    parameter Real xf = 0.60 "Mass fraction of KNO3 solids in feed";
    
    //=============
    // Variable Section 	
    Real cf (unit = "kg KNO3 / 100 kg H2O") "Mole ratio of KNO3 in feed solution";
    Real Ts (unit = "degC") "Saturation temperature of the feed solution";
    Real m1 (unit = "kg") "Mass of saturated solution leaving filter";
    Real m2 (unit = "kg KNO3 (s)") "Mass of solid KNO3 crystals from the filter";
    Real x (unit = "kg KNO3 / kg") "Concentration of KNO3 in saturated solution at 40 degC";
    Real s40 (unit = "kg KNO3 / 100 kg H2O") "Solubility of KNO3 at 40 degC";
    Real pcr (unit = "%") "Percentage recovery of KNO3";
    
    //=============
    // Equation Section 
    equation
        cf = xf / (1+xf) * 100;
        Ts =  74; //From graph in Fig6.5-1 page 266
        s40 = 63; //From Fig6.5-1 page 266, solubility of KNO3 is 63 g KNO3 / 100 g H2O
        x = s40 / (100 + s40); 
        m * (1 - xf) = m1 * (1 - x); //Water mass balance
        m = m1 + m2; //Overall mass balance
        pcr = m2 / (m * xf) *100;
        
end Ex6_5_2;