//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-6: Multiphase Systems
//Example: 6.6-1 Page 272
//Title: Extraction of Acetone from water
//===================================================================
model Ex6_6_1
    //=============
    // Parameter Section
    parameter Real roA (unit = "g/cm^3") = 0.792 "Density of acetone";
    parameter Real roW (unit = "g/cm^3") = 1 "Density of Water";
    parameter Real roC (unit = "g/cm^3") = 1.489 "Density of chloroform";
    parameter Real xA = 0.1 "Mass fraction of acetone in feed";
    parameter Real xW = 0.9 "Mass fraction of water in feed";
    parameter Real vf (unit = "cm^3") = 200 "Volume of feed";
    parameter Real vC (unit = "cm^3") = 400 "Volume of chloroform";
    parameter Real K = 1.72 "Distribution coefficient"; //From page 15.12 of Perry's Chemical Engineer's Handbook
    
    //=============
    // Variable Section 	
    Real ro_bar (unit = "g/cm^3") "Density of feed solution";
    Real mf (unit = "g") "Mass of feed";
    Real mC (unit = "g") "Mass of Chloroform";
    Real m1 (unit = "g A") "Mass of acetone in water phase";
    Real m2 (unit = "g W") "Mass of water";
    Real m3 (unit = "g A") "Mass of acetone in chloroform phase";
    Real m4 (unit = "g C") "Mass of chloroform";
    Real pct (unit = "%") "Percentage of acetone transferred";
    
    //=============
    // Equation Section 
    equation
        1/ro_bar = (xA / roA) + (xW / roW);
        mf = ro_bar * vf;
        mC = roC * vC;
        m4 = mC; //Chloroform balance
        K = (m3/(m4+m3)) / (m1/(m1+m2));
        xW * mf = m2; //Water balance
        xA * mf = m1 + m3; //Acetone balance
        pct = m3 / (xA*mf) *100;
        
end Ex6_6_1;