//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-6: Multiphase Systems
//Example: 6_7_1 Page 276
//Title: Balances on adsorption process
//===================================================================
model Ex6_7_1
    //=============
    // Parameter Section
    parameter Real V (unit = "L") = 50 "Volume of the tank";
    parameter Real P (unit = "atm") = 1 "pressure of the tank";
    parameter Real T (unit = "degC") = 34 "Temperature of tank";
    parameter Real R (unit = "L atm / mol K") = 0.08206 "Gas constant";
    parameter Real p_star_CCl4 (unit = "mmHg") = 169 "Vapour pressure of CCl4"; //Calculated from Antoine equation using constants from Table B.4
    parameter Real rel_sat = 0.3 "Initial relative saturation";
    parameter Real y0_final (unit = "mol CCl4 / mol") = 0.001 "Final mole fraction of CCl4";
    parameter Real a (unit = "g CCl4 /g C") = 0.794 "Langmuir constant"; //From text below Eq6.7-2 on page 276
    parameter Real KL (unit = "mmHg^-1") = 0.096 "Langmuir constant"; //From text below Eq6.7-2 on page 276
    
    //=============
    // Variable Section 	
    Real n (unit = "mol") "Moles of gas";
    Real y0_initial (unit = "mol CCl4 / mol") "Mole fraction of CCl4";
    Real p_CCl4 (unit = "mmHg") "Partial pressure of CCl4";
    Real X_CCl4_star (unit = "g CCl4 ads / gC") "Mass ratio of CCl4 adsorbed at equilibrium";
    Real m_ads (unit = "g CCl4") "Mass of CCl4 adsorbed";
    Real m_C (unit = "g C") "Mass of carbon required";
    
    //=============
    // Equation Section 
    equation
        n = P*V/R/(T+273.15); //To convert T from degC to K, we add 273.15
        rel_sat = y0_initial * P * 760 / p_star_CCl4; //To convert P from atm to mmHg, we multiply by 760
        p_CCl4 = y0_final * P *760 ; //To convert P from atm to mmHg, we multiply by 760
        X_CCl4_star = a* KL * p_CCl4 / (1+(KL*p_CCl4)); //Langmuir isotherm
        m_ads = (y0_initial - y0_final) * n * 154;//Molar mass of CCl4 is 154 g / mol
        m_C = m_ads / X_CCl4_star;
    
end Ex6_7_1;