//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-7: Energy and Energy balances
//Example: 7.2-1 Page 317
//Title: Kinetic Energy Transported by a flowing stream
//===================================================================
model Ex7_2_1
    //=============
    // Parameter Section
    parameter Real d (unit = "cm") = 2  "Internal diameter of pipe";
    parameter Real v_dot (unit = "m^3/h") = 2 "Volumetric flow rate";
    import Modelica.Constants.pi;
    //=============
    // Variable Section 	
    Real m_dot (unit = "kg/s") "Mass flow rate of water";
    Real u (unit = "m/s") "Linear velocity of water in pipe";
    Real E_dot_k (unit = "J/s") "Kinetic energy rate";
    
    //=============
    // Equation Section 
    equation
        u = v_dot * (100^2) / (pi * (d/2)^2) / 3600;
        m_dot = v_dot * 1000 / 3600;
        E_dot_k = m_dot * u^2 /2;
        
end Ex7_2_1;