//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-7: Energy and Energy balances
//Example: 7.2-2 Page 317
//Title: Potential Energy Increase of a Flowing Fluid
//===================================================================
model Ex7_2_2
    //=============
    // Parameter Section
    parameter Real m_dot (unit = "kg/s") = 15.0 "Mass flow rate of water";
    parameter Real z1 (unit = "m") = -220 "Initial height of the fluid";
    parameter Real z2 (unit = "m") = 20 "Final height of the fluid";
    import Modelica.Constants.g_n; //Acceleration due to gravity
    
    //=============
    // Variable Section 	
    
    Real del_Ep_dot (unit = "J/s") "Rate of increase of potential energy";
    
    //=============
    // Equation Section 
    equation
        del_Ep_dot = m_dot * g_n * (z2 - z1);
        
end Ex7_2_2;