//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-8: Balances on Nonreactive Processes
//Example: 8.3-1 Page 367
//Title: Evaluation of an Integral Energy Change from Tabulated Heat Capacity
//===================================================================
model Ex8_3_1
    //=============
    // Parameter Section
    parameter Real m (unit = "kg") = 200 "Mass of nitrous oxide";
    parameter Real T1 (unit = "degC") = 20 "Initial temperature";
    parameter Real T2 (unit = "degC") = 150 "Final temperature";
   
    //=============
    // Variable Section
    Real delUcap (unit = "kJ/kg") "specific Internal energy change";
    Real delU (unit = "kJ") "Internal energy change";
    Real Q (unit = "kJ") "Heat required";
    
    //=============
    // Equation Section 
    equation
        delUcap = (0.855 * (T2 - T1)) + (9.42e-4 /2 * (T2^2 - T1^2)); //Integrated expression
        delU = m*delUcap;
        Q = delU;
        
end Ex8_3_1;