//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-8: Balances on Nonreactive Processes
//Example: 8.3-5 Page 374
//Title: Energy balance on a Gas Preheater
//===================================================================
model Ex8_3_5
    //=============
    // Parameter Section
    parameter Real [4] const = {0.03431,5.469e-5,0.3661e-8,-11e-12}; //Polynomial coefficients for methane
    //Polynomial formula for specific heat are taken from Table B.2 Appendix B
    parameter Real x1 = 0.1 "Mole fraction of methane in feed";
    parameter Real x2 = 0.9 "Mole fraction of air in feed";
    parameter Real T1 (unit = "degC") = 20 "Initial temperature";
    parameter Real T2 (unit = "degC") = 300 "Final temperature";
    parameter Real V_dot (unit = "L/min") = 2000 "Volumetric flow rate of the gas mixture at STP";
    
    //=============
    // Variable Section
    Real n_dot (unit = "mol/h") "Molar flow rate of mixture";    
    Real delH1cap (unit = "kJ/mol") "Specific Enthalpy change for methane";
    Real H2cap (unit = "kJ/mol") "Specific Enthalpy of air at 20 degC";
    Real H3cap (unit = "kJ/mol") "Specific Enthalpy of air at 300 degC";
    Real delH_dot (unit = "kJ/h") "Enthalpy  change";
    Real Q_dot (unit = "kW") "Heat required";
    
    //=============
    // Equation Section 
    equation
        n_dot = V_dot / 22.4;
        delH1cap = ((const[1]* (T2 - T1)) + (const[2] /2 * (T2^2 - T1^2)) + (const[3] /3 * (T2^3 - T1^3)) + (const[4] /4 * (T2^4 - T1^4)));
        H2cap = -0.15; //From table B.8
        H3cap = 8.17; //From table B.8
        //Above equation is the integrated equation with limits substituted
        delH_dot = n_dot * x1 * delH1cap + n_dot * x2 * (H3cap - H2cap);
        Q_dot = delH_dot / 60;
        
end Ex8_3_5;
//===================================================================