//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-8: Balances on Nonreactive Processes
//Example: 8.4-4 Page 383
//Title: Partial Vaporization of a Mixture
//===================================================================
model Ex8_4_4
    //=============
    // Parameter Section
    parameter Real n (unit = "mol") = 1 "Moles charged into the evaporator";
    parameter Real xF (unit = "mol B/ mol") = 0.5 "Mole fraction of benzene in feed";
    parameter Real xV (unit = "mol B/ mol") = 0.684 "Mole fraction of benzene in vapour";
    parameter Real xL (unit = "mol B/ mol") = 0.4 "Mole fraction of benzene in liquid";
    parameter Real delHcap_vB (unit = "kJ/mol") = 30.765 "Enthalpy of vaporisation of benzene";//Table B.1 Page 631
    parameter Real delHcap_vT (unit = "kJ/mol") = 33.47 "Enthalpy of vaporisation of toluene";//Table B.1 Page 634
    parameter Real [2] const_Bl = {126.5e-3, 23.4e-5} "Polynomial coefficients for benzene liquid"; //Table B.2 Page 635
    parameter Real [4] const_Bv = {74.06e-3, 32.95e-5, -25.20e-8, 77.57e-12} "Polynomial coefficients for benzene vapour"; //Table B.2 Page 635
    parameter Real [2] const_Tl = {148.8e-3, 32.4e-5} "Polynomial coefficients for toluene liquid"; //Table B.2 page 637
    parameter Real [4] const_Tv = {94.18e-3, 38.00e-5, -27.86e-8, 80.33e-12} "Polynomial coefficients for toluene vapour";//Table B.2 page 637
    parameter Real T_i (unit ="degC") =10 "Inlet temperature";
    parameter Real T_o (unit ="degC") =50 "Outlet temperature";
    parameter Real T_bp_B (unit = "degC") = 80.1 "Boiling point of benzene";
    parameter Real T_bp_T (unit = "degC") = 110.62 "Boiling point of toluene";
    
    //=============
    // Variable Section
    Real n_V (unit = "mol") "Moles of vapour leaving evaporator";
    Real n_L (unit = "mol") "Moles of liquid leaving evaporator";
    Real delHcap_1 (unit = "kJ/mol") "Specific enthalpy of liquid benzene at exit";
    Real delHcap_2 (unit = "kJ/mol") "Specific enthalpy of liquid toluene at exit";
    Real delHcap_3 (unit = "kJ/mol") "Specific enthalpy of gaseous benzene at exit";
    Real delHcap_4 (unit = "kJ/mol") "Specific enthalpy of gaseous benzene at exit";
    Real Q (unit = "kJ") "Heat required by the evaporator";
    
    //=============
    // Equation Section 
    equation
        delHcap_1 = ((const_Bl[1]* (T_o - T_i)) + (const_Bl[2] /2 * (T_o^2 - T_i^2)));
        delHcap_2 = ((const_Tl[1]* (T_o - T_i)) + (const_Tl[2] /2 * (T_o^2 - T_i^2)));
        delHcap_3 = ((const_Bl[1]* (T_bp_B - T_i)) + (const_Bl[2] /2 * (T_bp_B^2 - T_i^2))) + delHcap_vB + ((const_Bv[1]* (T_o - T_bp_B)) + (const_Bv[2] /2 * (T_o^2 - T_bp_B^2)) + (const_Bv[3] /3 * (T_o^3 - T_bp_B^3)) + (const_Bv[4] /4 * (T_o^4 - T_bp_B^4)));
        delHcap_4 = ((const_Tl[1]* (T_bp_T - T_i)) + (const_Tl[2] /2 * (T_bp_T^2 - T_i^2))) + delHcap_vT + ((const_Tv[1]* (T_o - T_bp_T)) + (const_Tv[2] /2 * (T_o^2 - T_bp_T^2)) + (const_Tv[3] /3 * (T_o^3 - T_bp_T^3)) + (const_Tv[4] /4 * (T_o^4 - T_bp_T^4)));
        n = n_L + n_V; //Mass balance
        xF*n = xL*n_L + xV*n_V; //Benzene balance
        Q = (xV*n_V*delHcap_3) + ((1-xV)*n_V*delHcap_4) + (xL*n_L*delHcap_1) + ((1-xL)*n_L*delHcap_2);
        
end Ex8_4_4;
//===================================================================