//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-8: Balances on Nonreactive Processes
//Example: 8.5-1 Page 397
//Title: Production of Hydrochloric Acid
//===================================================================
model Ex8_5_1
    //=============
    // Parameter Section
    parameter Real m_dot (unit = "kg/h") = 1000 "Mass flow rate of HCl aq";
    parameter Real x_HCl  =0.20 "Mass fraction of HCl in aqueous solution";
    parameter Real [4] const = {29.13e-3, -0.1341e-5, 0.9715e-8, -4.335e-12}; //Polynomial coefficients for HCl gas
    parameter Real T_final (unit = "degC") = 40 "Exit gas temperature";
    parameter Real T_i (unit = "degC") = 100 "Inlet gas temperature";    
    
    //=============
    // Variable Section
    Real n_dot_HCl (unit = "mol HCl /h") "Molar flow rate of HCl";
    Real n_dot_H2O (unit = "mol H2O /h") "Molar flow rate of H2O";
    Real Hcap_1 (unit = "kJ/mol HCl") "Specific enthalpy of HCl gas";
    Real Hcap_2 (unit = "kJ/mol HCl") "Specific enthalpy of aq HCl at exit";
    Real Hcap_a (unit = "kJ/mol HCl") "Specific enthalpy of aq HCl at exit";
    Real Hcap_b (unit = "kJ/mol HCl") "Specific enthalpy of aq HCl at exit";
    Real y_HCl (unit = "mol HCl/ mol") "Mole fraction of HCl";
    Real Cp (unit = "kJ/ mol HCl degC") "Specific heat of HCl solution"; 
    Real Q_dot (unit = "kJ/h") "Heat requirement rate";
    
    //=============
    // Equation Section 
    equation
        n_dot_HCl = m_dot * x_HCl / 36.5 * 1e3;
        n_dot_H2O = m_dot * (1-x_HCl) /18 * 1e3;
        Hcap_1 = ((const[1]* (T_i - 25)) + (const[2] /2 * (T_i^2 - 25^2)) + (const[3] /3 * (T_i^3 - 25^3)) + (const[4] /4 * (T_i^4 - 25^4)));
        y_HCl = n_dot_HCl / (n_dot_HCl + n_dot_H2O);
        Hcap_a = -67.4; //Table B.11 page 653
        Cp = 0.73 * 1000 / n_dot_HCl * 4.184; //From Perry's Chemical Engineer's Handbook page 2-184
        Hcap_b = Cp * (T_final - 25);
        Hcap_2 = Hcap_a + Hcap_b;
        Q_dot = n_dot_HCl * (Hcap_2 - Hcap_1);
        
end Ex8_5_1;
//===================================================================