//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-8: Balances on Nonreactive Processes
//Example: 8.5-2 Page 400
//Title: Concentration of an Aqueous H2SO4 Solution
//===================================================================
model Ex8_5_2
    //=============
    // Parameter Section
    parameter Real mdot (unit = "lb/h") = 1000 "Mass flow rate of HCl aq";
    parameter Real x1  =0.05 "Initial mass fraction of H2SO4";
    parameter Real x2  =0.4 "Final mass fraction of H2SO4";
    parameter Real T_f (unit = "degF") = 180 "Exit temperature";
    parameter Real T_i (unit = "degF") = 60 "Inlet temperature";    
    
    //=============
    // Variable Section
    Real HcapF (unit = "Btu /lb") "Specific enthalpy of feed";
    Real HcapV (unit = "Btu /lb") "Specific enthalpy of vapour";
    Real HcapL (unit = "Btu /lb") "Specific enthalpy of product";
    Real m1dot (unit = "lb /h") "Mass flow rate of vapour";
    Real m2dot (unit = "lb /h") "Mass flow rate of concentrate";
    Real Qdot (unit = "Btu/h") "Heat transfer rate";
    
    //=============
    // Equation Section 
    equation
        mdot = m1dot + m2dot; //Mass balance
        mdot*x1 = x2*m2dot; //H2SO4 component balance
        HcapF = 10; //Figure 8.5-1 Page 399
        HcapL = -17; //Figure 8.5-1 Page 399
        HcapV = 1138; //Steam Tables for steam at 180 degF and 1 atm
        Qdot = m1dot*HcapV + m2dot*HcapL - mdot*HcapF;
        
        
end Ex8_5_2;
//===================================================================