//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-8: Balances on Nonreactive Processes
//Example: 8.5-3 Page 402
//Title: Adiabatic Mixing
//===================================================================
model Ex8_5_3
    //=============
    // Parameter Section
    parameter Real m (unit = "g") = 100 "Mass of 80% H2SO4 added";
    parameter Real Ti (unit = "degF") = 60 "Initial temperature of water";
    parameter Real x1 = 0.80 "Mass fraction of H2SO4 in added solution";
    parameter Real m_w (unit = "g") = 250 "Mass of water mixed";
    
    //=============
    // Variable Section
    Real xp "Final mass fraction of H2SO4";
    Real Tf (unit = "degF") "Final solution temperature";
    Real Tmax (unit = "degF") "Maximum attainable solution temperature";
    Real xmax "Mass fraction of H2SO4 corresponding to maximum final solution temperature";
    Real m_w_2 (unit = "g") "Amount of water to be added to attain maximum temperature";
    
    //=============
    // Equation Section 
    equation
        xp = (m_w * 0 + m * x1) / (m_w + m);
        Tf = 100; //From figure 8.5-1 page 399
        Tmax = 150; //From figure 8.5-1 page 399
        xmax = 0.58; //From figure 8.5-1 page 399
        xmax = (m_w_2 * 0 + m * x1) / (m_w_2 + m);
end Ex8_5_3;
//===================================================================