//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-9: Balances on Reactive Processes
//Example: 9.5-2 Page 454
//Title: Energy Balance on a Methane Oxidation Reactor
//===================================================================
model Ex9_5_2
    //Reaction given is 4 N2 + 5 O2 -> 4 NO + 6 H2O
    //=============
    // Parameter Section
    parameter Real [4] cp_CH4 = {34.31e-3, 5.469e-5, 0.3661e-8, -11e-12} "Polynomial coefficients of Cp of CH4"; //Table B.2 page 636
    parameter Real [4] cp_HCHO = {34.28e-3, 4.268e-5, 0, -8.694e-12} "Polynomial coefficients of Cp of HCHO"; //Table B.2 page 636
    parameter Real ndot_in_CH4 (unit = "mol/s") = 100 "Inlet mole rate of CH4";
    parameter Real ndot_in_O2 (unit = "mol/s") = 100 "Inlet mole rate of O2";
    parameter Real ndot_in_N2 (unit = "mol/s") = 376 "Inlet mole rate of N2";
    parameter Real ndot_out_CH4 (unit = "mol/s") = 60 "Outlet mole rate of CH4";
    parameter Real ndot_out_O2 (unit = "mol/s") = 50 "Outlet mole rate of O2";
    parameter Real ndot_out_N2 (unit = "mol/s") = 376 "Outlet mole rate of N2";
    parameter Real ndot_out_HCHO (unit = "mol/s") = 30 "Outlet mole rate of HCHO";
    parameter Real ndot_out_CO2 (unit = "mol/s") = 10 "Outlet mole rate of CO2";
    parameter Real ndot_out_H2O (unit = "mol/s") = 50 "Outlet mole rate of H2O";
        
    //=============
    // Variable Section
    Real H1cap (unit = "kJ/mol") "Specific enthalpy of CH4 at inlet";
    Real H2cap (unit = "kJ/mol") "Specific enthalpy of O2 at inlet";
    Real H3cap (unit = "kJ/mol") "Specific enthalpy of N2 at inlet";
    Real H4cap (unit = "kJ/mol") "Specific enthalpy of CH4 at outlet";
    Real H5cap (unit = "kJ/mol") "Specific enthalpy of O2 at outlet";
    Real H6cap (unit = "kJ/mol") "Specific enthalpy of N2 at outlet";
    Real H7cap (unit = "kJ/mol") "Specific enthalpy of HCHO at outlet";
    Real H8cap (unit = "kJ/mol") "Specific enthalpy of CO2 at outlet";
    Real H9cap (unit = "kJ/mol") "Specific enthalpy of H2O at outlet";
    Real Q (unit = "kJ") "Heat requirement";
    
    //=============
    // Equation Section 
    equation
        H1cap = -74.85; //Enthalpy o formation of CH4 at 25 degC from Table B.1 page 628 - 634
        H2cap = 2.235; //Specific enthalpy of O2 from Table B.8
        H3cap = 2.187; //Specific enthalpy of N2 from Table B.8
        H4cap = H1cap + (cp_CH4[1] * (150 - 25)) + (cp_CH4[2]/2 * (150^2 - 25^2)) + (cp_CH4[3]/3 * (150^3 - 25^3)) + (cp_CH4[4]/4 * (150^4 - 25^4)) ;
        H5cap = 3.758; //Specific enthalpy of O2 from Table B.8
        H6cap = 3.655; //Specific enthalpy of N2 from Table B.8
        H7cap = -115.9 + (cp_HCHO[1] * (150 - 25)) + (cp_HCHO[2]/2 * (150^2 - 25^2)) + (cp_HCHO[3]/3 * (150^3 - 25^3)) + (cp_HCHO[4]/4 * (150^4 - 25^4)) ;
        H8cap = -393.5 + 4.75; //Enthalpy of formation of CO2 is -393.5 and specific enthalpy of CO2 is 4.75
        H9cap = -241.83 + 4.27; //Enthalpy of formation of H2O is -241.83 and specific enthalpy of H2O is 4.27
        Q = -ndot_in_CH4 * H1cap -ndot_in_O2 * H2cap - ndot_in_N2 * H3cap + ndot_out_CH4 * H4cap + ndot_out_O2 * H5cap + ndot_out_N2 * H6cap + ndot_out_HCHO * H7cap + ndot_out_CO2 * H8cap +  ndot_out_H2O * H9cap;
        
         
end Ex9_5_2;